/*------------------------------------------------------------------------------*
 *	File Name: 	DialogMessages.h												*
 *	Purpose:	OC level ID's for Dialog Msg and Handler prototypes				* 
 *																				*
 *																				*
 *	Author:		TD																*
 *  Creation:	10-31-02														*
 *  	Copyright (c) OriginLab Corp. 2000-2003									*
 *																				*
 *	Modification log     														*
 *	Created TD 10/29/02 QA70-3182 v7.0424	OCDIALOG_MSG_MAP_IMPLEMENT			*
 *	CPY v7.0469 12/19/02 QA70-3526 SKIP_PAGES_FROM_OC							*
 *	TD 12-27-02 ORIGINC_ACCESS_TO_EDIT_ON_RETURN								*
 *	CPY 12-28-02 QA70-3589 ORIGINC_ACCESS_TO_PRETRANSLATE_KEY_MSG				*
 *	TD 1-8-03 QA70-3630 v7.0481 EVENT_SINK_FOR_DIALOG_BUILDER					*
 *	CPY 1/28/03 QA70-3796 COL_CHANGE_NOTIFICATIONS								*
 *	RVD 3/17/2003 QA70-3855 v7.0539 SYSTEM_THEME								*
 *	TD 4-14-03 QA70-4258 ADD_PAGE_ONKILLACTIVE									*
 *	TD 10-21-03 QA70-5754 PROPERTY_SHEET_AND_WIZARD_CLASS_IN_OC					*
 *	YuI 3/24/04 v7.5846 QA70-6118 NEW_DATA_SELECTOR_TOOL						*
 *	TD 3-21-05 QA70-7526 FUNCTION_TO_GET_CONTROL_TYPE							*
 *	TD 4-13-05 POST_DIALOG_MESSAGE_ON_NAME_CHANGE								*
 *	TD 9-21-05 QA70-8124 DIALOG_BUILDER_AND_CHILD_DIALOGS						*
 *	TD 5-15-06 QA70-8579 SAVING_OXF_IN_PROJECTS_TEMPALTES_AND_SINGLE_WINDOWS	*
 *	TD 1-30-07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS					*
 *	YuI 10/12/07 QA70-10529 DATA_MARKERS_REVAMP									*
 *	YuI 04/09/08 QA70-11394 GETN_CONTROL_FOR_SYMBOL_WELL						*
 *	Sim 11-22-2008 QA80-12505 SUPPORT_POST_OC_MESSAGE_TO_SPECIFIED_WINDOW		*
 *	EJP 2009-05-07 QA80-13573 UPDATE_ORGANIZER_WHEN_CHANGE_SHEET_ORDER			*
 *	EJP 2009-05-13 QA80-13573 UPDATE_ORGANIZER_WHEN_CHANGE_SHEET_NAME			*
 *	Folger 06/08/09 LAYER_DESTROY_DIALOG_MESSAGE_FOR_OC							*
 *	Folger 04/13/10 QA81-15309 OC_POST_ORIGIN_MESSAGE_SUPPORT					*
 *------------------------------------------------------------------------------*/

#ifndef _DIALOGMESSAGES_H_
#define _DIALOGMESSAGES_H_

//------ CPY 3/27/09 ALLOW_OC_TO_BE_81_FOR_SR6
/*
//this defined only in common.h so need duplicate def.
#ifdef __AFX_H__
#ifdef _ORIGIN_VER_8_
	#define		_OC_VER		0x0800
#else
	#ifndef _POST_ORIGIN7_
		#define		_OC_VER		0x0703
	#else
		#define   _OC_VER		0x0750
	#endif
#endif
#endif	//__AFX_H__
*/
//----- end ALLOW_OC_TO_BE_81_FOR_SR6

//---- CPY 4/3/08 QA70-11370 SPLITTER_MSG_AND_OE_MSG_CONFLICT_LEAD_TO_NLFIT_DLG_NOT_OPEN, added comments below

#define		MT_DLG					0x00000100	   //CPY 4/3/08 DDK SN_* messages
#define		MT_WND					0x00000200	   //CPY 4/3/08 WM_* messages
#define		MT_ORG					0x00000300	   //CPY 4/3/08 Origin OE_* events
#define		MT_EVNT					0x00000400				///	TD 1-8-03 QA70-3630 v7.0481 EVENT_SINK_FOR_DIALOG_BUILDER

// As per Marko's suggestion not making things harder by demanding user to know what's notify and what's command
// Since then most times they will have to try both and check which is which 
// leaving the info here for the time being incase we want to do this
//#define		MFC_COMMAND				0x00010000
//#define		MFC_NOTIFY				0x00020000

#define MT_FILTER(_ID)		(0x0000FF00 & (_ID)) 
#define MHO_FILTER(_ID)		(0x000000FF & (_ID)) 
//#define MFC_FILTER(_ID)		(0x00FF0000 & (_ID))



// Dialog Messages, corresponding to MFC CDialog Virtual functions and DialogBuilder specific
enum
{
	SN_INIT = 1,
	SN_ON_INIT,	
	SN_ONREADY,
	SN_OK,
	SN_APPLY,
	SN_NEXT,
	SN_FINISH,
	SN_CANCEL,
	SN_BACK,
	SN_HELP,
	SN_ACTIVE,
	SN_WINDOW_PROC,
	SN_IS_SHOW_PAGE,  //CPY v7.0469 12/19/02 QA70-3526 SKIP_PAGES_FROM_OC
	SN_KILLACTIVE,	/// TD 4-14-03 QA70-4258 ADD_PAGE_ONKILLACTIVE
	SN_RESET,		/// TD 4-22-03 QA70-3608 MORE_WORK_IN_DDK
	SN_ONKEY, /// TD 6-10-03 QA70-4631 MODAL_TO_BE_NOMODAL_ON_ROLLUP
	SN_ON_INIT_RESIZE, /// TD 9-8-03 QA70-NOTRACKER OCMSG_ON_RESIZE_BY_INI
	SN_PAGE_SPLITTER_READY, /// TD 9-21-05 QA70-8124 DIALOG_BUILDER_AND_CHILD_DIALOGS
	SN_OC_RESIZEINFO,/// TD 1-30-07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
};


#if _OC_VER >= 0x0800	
#define SN_OC_OFFSET		200
#else //#if _OC_VER >= 0x0800
#define SN_OC_OFFSET		0
#endif //#if _OC_VER >= 0x0800


// Origin Messages, 
enum
{
	//LY 12/3/02 v7.0452 QA70-3422 CENTRALIZE_DDK_MSG_HANDLING
	//SN_ONMDIACTIVATE = 1,
	/// TD 11-4-04 QA70-7124 GENERAL_EVENTS_FIRED_ON_IMPORT
	//SN_ACTIVE_WINDOW = 0,
	SN_ACTIVE_WINDOW = SN_OC_OFFSET,
	/// end GENERAL_EVENTS_FIRED_ON_IMPORT
	SN_ACTIVE_PAGE,			//different to the SN_ACTIVE_WINDOW due to note page
	SN_ACTIVE_LAYER,
	SN_ACTIVE_SELECTION,
	
	/// YuI 01/30/04 v7.5811 QA70-5908 NOMINAL_CATEGORICAL_MAP_INIT_PROBLEM
	SN_ACTIVE_SELECTION_TRACK,  // for process of selection in wks. 
	/// end NOMINAL_CATEGORICAL_MAP_INIT_PROBLEM

	/// YuI 3/24/04 v7.5846 QA70-6118 NEW_DATA_SELECTOR_TOOL
	SN_DS_SELECTION_CHANGE,
	SN_DS_SELECTION_TRACK,
	SN_DS_SELECTION_OK,
	SN_DS_SELECTION_CANCEL,
	/// end NEW_DATA_SELECTOR_TOOL

	/// YuI 10/12/07 QA70-10529 DATA_MARKERS_REVAMP
	SN_DS_MARKER_CREATE,
	SN_DS_MARKER_DESTROY,
	/// end DATA_MARKERS_REVAMP

	SN_ACTIVE_DATASET,
	SN_NUM_ORIGIN_OBJECTS,
	// other non Origin object notifications
	SN_ONMDIACTIVATE,
	//LY 12/3/02 QA70-3422 CENTRALIZE_DDK_MSG_HANDLING	   
	SN_ONMDIDEACTIVATE,
	SN_ONLAYERACTIVATE,
	SN_ONDATASETACTIVATE,

	//------- CPY 1/28/03 QA70-3796 COL_CHANGE_NOTIFICATIONS
	SN_COL_CHANGE_FORMAT,
	SN_COL_CHANGE_PLOT_DESIGNATION,
	SN_COL_CHANGE_ANALYSIS, // formula, auto update ranged
	SN_COL_CHANGE_RANGE,
	//------- end CPY 1/28/03 QA70-3796 COL_CHANGE_NOTIFICATIONS

	// message is generated by new DataSelector tool
	SN_ONIDLE,

	SN_ON_MODIFY,
	SN_ON_MODIFY_INFO,

	/// TD 11-10-04 QA70-5346 EDITING_DIALOGBUILDER_GRAPHS_IN_ORIGIN_WORKSPACE
	SN_ON_PAGE_CONTROL,//wParam = Attach/Detach, lParam = Before/After
	/// end EDITING_DIALOGBUILDER_GRAPHS_IN_ORIGIN_WORKSPACE

	SN_LOOSE_DATASET_CHANGE,	//---- CPY QA70-7860 7/6/05 LOOSE_DATASET_EDIT_UPDATE

	//---- CPY QA70-7860 10/14/05 LT_VARS_EDIT_UPDATE
	SN_LT_USR_NUMERIC_VAR_CHANGE,
	SN_LT_USR_STR_VAR_CHANGE,
	SN_LT_TREE_VAR_CHANGE,
	SN_ON_AFTER_LOAD_FILE, /// TD 5-15-06 QA70-8579 SAVING_OXF_IN_PROJECTS_TEMPALTES_AND_SINGLE_WINDOWS
	//-----
	
	//----- CPY 10/27/2007 QA70-10600 PAGE_CREATE_DESTROY_MSGS
	SN_ON_PAGE_CREATE,
	SN_ON_PAGE_DESTROY,
	//-----

	///---Sim 11-22-2008 QA80-12505 SUPPORT_POST_OC_MESSAGE_TO_SPECIFIED_WINDOW
	SN_ON_DATA_CHANGE,
	///---END QA80-12505 SUPPORT_POST_OC_MESSAGE_TO_SPECIFIED_WINDOW

	SN_ON_LAYER_DESTROY,		///------ Folger 06/08/09 LAYER_DESTROY_DIALOG_MESSAGE_FOR_OC

	///------ Folger 04/13/10 QA81-15309 OC_POST_ORIGIN_MESSAGE_SUPPORT
	SN_ON_FITTING_FUNCTION_CHANGE,
	///------ End OC_POST_ORIGIN_MESSAGE_SUPPORT

	////////////////////
	// all SN message must
	// be above this one
	////////////////////
	SN_END_MSG //---- CPY QA70-7860 7/6/05 LOOSE_DATASET_EDIT_UPDATE
};


/// TD 11-4-04 QA70-7124 GENERAL_EVENTS_FIRED_ON_IMPORT
//The following bits apply to the WPARAM for the following messages 
//OE_ON_MODIFY,
//OE_ON_MODIFY_INFO,
enum
{
  OE_OM_SIZE = 0x00000001,
  OE_OM_DATA = 0x00000002,
  OE_OM_NAME = 0x00000004,/// TD 4-13-05 POST_DIALOG_MESSAGE_ON_NAME_CHANGE
  OE_OM_LAYERORDER = 0x00000008, /// EJP 2009-05-07 QA80-13573 UPDATE_ORGANIZER_WHEN_CHANGE_SHEET_ORDER
  OE_OM_RENAMELAYER = 0x00000010, /// EJP 2009-05-13 QA80-13573 UPDATE_ORGANIZER_WHEN_CHANGE_SHEET_NAME
};

/// end GENERAL_EVENTS_FIRED_ON_IMPORT



/// TD 10-21-03 QA70-5067 PROPERTY_SHEET_AND_WIZARD_CLASS_IN_OC
enum{
	RESIZE_DEPENDENCY_DOMINANT_NONE,
	RESIZE_DEPENDENCY_DOMINANT_PAGE,
	RESIZE_DEPENDENCY_DOMINANT_DIALOG,
};
/// end PROPERTY_SHEET_AND_WIZARD_CLASS_IN_OC

/// TD 12-19-03 QA70-5754 VIRTUAL_ON_PAGE_SHOW
enum
{
	PSS_Hide,
	PSS_Show,
	PSS_Ignore,
};
/// end VIRTUAL_ON_PAGE_SHOW


//--------- CPY 12-28-02 QA70-3589 ORIGINC_ACCESS_TO_PRETRANSLATE_KEY_MSG
//outside EN_VSCROLL etc range
///// TD 12-27-02 QA70-3589 ORIGINC_ACCESS_TO_EDIT_ON_RETURN
//#define DDK_DLG_CTRL_MSG_EDITBOX_RETURN				1000
/// end ORIGINC_ACCESS_TO_EDIT_ON_RETURN
enum{
	OC_NOTIFICATION_KEY = 0x2000,
	OC_NOTIFICATION_EDITBOX_RETURN,
	OC_NOTIFICATION_OLE_DROP,/// TD 10-14-03 QA70-5322 DROPING_DATA_INTO_ORIGIN_FROM_DBX_CONTROL
};
#define DDK_DLG_CTRL_MSG_EDITBOX_RETURN	OC_NOTIFICATION_EDITBOX_RETURN
//--------- end CPY 12-28-02 QA70-3589 ORIGINC_ACCESS_TO_PRETRANSLATE_KEY_MSG
/// TD 2-14-05 QA70-7403 XFUNCTION_IDE
#define WM_USER_XFC_DOC_CLOSE			(WM_USER + 450)
#define WM_USER_XFC_DOC_SAVE			(WM_USER + 451)
#define WM_USER_XFC_ON_FINISH_COMPILE	(WM_USER + 452)
/// end  XFUNCTION_IDE
/// TD 8-15-05 QA70-8005 AUTO_COMPLTE_IN_CODEEDIT
#define WM_USER_AUTOCOMPLETE_DONE						WM_USER+444
#define WM_USER_AUTOCOMPLETE_GET_DISPLAY_STRING			WM_USER+445
#define WM_USER_AUTOCOMPLETE_ON_REPLACE_SEL				WM_USER+446	//CPY 9/10/05 AUTO_COMPLETE_ALLOW_IMMEDIATE_OPEN
/// end AUTO_COMPLTE_IN_CODEEDIT

/// YuI 04/09/08 QA70-11394 GETN_CONTROL_FOR_SYMBOL_WELL
// moved from colrwell.h
#define CWN_COLOR_CHANGE		(WM_USER+101)
#define CWN_CUSTOM_COLOR		(WM_USER+102)

#define SYMBOL_WELL_GALERY_SMALL_WIDTH	11
/// end GETN_CONTROL_FOR_SYMBOL_WELL


/// TD 3-21-05 QA70-7526 FUNCTION_TO_GET_CONTROL_TYPE
enum {
	CN_UNKNOWN = 0,
	CN_BUTTON = 1,
	CN_COMBO,
	CN_LISTBOX,
	CN_LISTVIEW,
	CN_STATIC,
	CN_PATHCTRL,
	CN_EDITBOX,
	CN_SPINCTRL,
	CN_SLIDERCTRL,	
	CN_RICHEDITCTRL,
	CN_PROGRESSBOX,
	CN_TOOLBAR,
	CN_TABCONTROL,
	//special types
	CN_BITMAPRADIOBUTTON,
	CN_WORKSHEETCONTROL,
	CN_GRAPHCONTROL,
	CN_PICTURECONTROL,

};
/// end FUNCTION_TO_GET_CONTROL_TYPE


#endif //_DIALOGMESSAGES_H_